<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();

// Include the centralized database config file
include 'config.php';

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Initialize variables for error messages
$error = "";

// Process form submission
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $username = $_POST['username'];
    $password = $_POST['password'];

    // Sanitize input to prevent SQL injection
    $username = $conn->real_escape_string($username);

    // Check if user exists and password is correct
    $sql = "SELECT * FROM users WHERE username = '$username'";
    $result = $conn->query($sql);

    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        // Check password
        if (password_verify($password, $row['password'])) {
            // Set session variables
            $_SESSION['user_id'] = $row['id']; // Assuming 'id' is the user ID column
            $_SESSION['status'] = $row['status'];

            // Check account status and redirect
            if ($row['status'] == 1) {
                header("Location: dashboard.php");
                exit();
            } elseif ($row['status'] == 2) {
                header("Location: dashboardadmin.php");
                exit();
            }
        } else {
            $error = "Invalid username or password.";
        }
    } else {
        $error = "Invalid username or password.";
    }
}

$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Stack Investments - Login</title>
    <link rel="stylesheet" href="styles.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
</head>
<body>
    <div class="login-container">
        <div class="login-box">
            <center>
                <h1>STACK</h1>
                <h2>Investor Login</h2>
                <br>
                <div class="login-box2">
                    <form method="POST" action="">
                        <input type="text" id="username" name="username" placeholder="Username" required>
                        <input type="password" id="password" name="password" placeholder="Password" required>
                        <button type="submit" style="width:100%;">Log In</button>
                        <?php
                        if (!empty($error)) {
                            echo "<p style='color:red;'>$error</p>";
                        }
                        ?>
                    </form>
                </div>
            </center>
        </div>
    </div>
</body>
</html>
